unit main;

interface

uses
    Windows, Messages, SysUtils,
    Classes, Graphics, Controls, Forms,
    Dialogs, StdCtrls, Ry2dp, head;

type
    TForm1 = class(TForm)
    List: TListBox;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    procedure FormCreate(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Button1Click(Sender: TObject);
    private
        { Private declarations }
    public
        { Public declarations }
    end;

var
    Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
begin
    List.Items.Clear();
    RY2_Init();
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
    RY2_Finish();
end;

procedure TForm1.Button2Click(Sender: TObject);
var
retcode ,handle:integer;
uid,hid,version:Longword;

str :string;
strid:ansistring;
begin
 	// generate UID
	// There must be one dongle pluging in computer when generating UID,so we don't care the UID and
	//  HID of it .We only use the first dongle.
    retcode := RY2_Find();
    if retcode < 0 then
    begin
        FmtStr(str,'ERROR: %x;', [retcode]);
        List.Items.Add(str);
        Exit;
    end;
    if retcode = 0 then
    begin
        List.Items.Add('ERROR: Not found any rockey2');
        Exit;
    end;
    FmtStr(str,'Find: %x rockey2;', [retcode]);
    List.Items.Add(str);

    retcode := RY2_Open(AUTO_MODE, 0, @hid);
    if retcode < 0 then
    begin
        FmtStr(str, 'ERROR of RY2_Open : %x', [retcode]);
        List.Items.Add(str);
        Exit;
    end;
    handle := retcode;

    strid := Inputbox('Input','Please input seed : ','12345');
    retcode := RY2_GenUID(handle, @uid, PAnsiChar(strid), ROCKEY2_DISABLE_WRITE_PROTECT);
    if retcode < 0 then
    begin
        FmtStr(str, 'ERROR: %x', [retcode]);
        List.Items.Add(str);
        Exit;
    end ;
    FmtStr(str,'UID is %d', [uid]);
    List.Items.Add(str);
    
    version:=RY2_GetVersion(handle);
    if version=0 then
    begin
        List.Items.Add('Get Version ERROR');
        Exit;
    end ;
    FmtStr(str, '%d.%d', [word(version) shr 8,word(version) and $ff]);
    FmtStr(str, 'Version: %s', [str]);
    List.Items.Add(str);
    RY2_Close(handle);
	
	// after generated new UID, the flag of dongle has changed,you must plug out it and re-plug again
    List.Items.Add('You must plug out Rockey2 and re-plug to enable new uid.');
end;

procedure TForm1.Button3Click(Sender: TObject);
var
retcode ,handle,block_index:integer;
uid,hid:cardinal;
str :string;
str1:ansistring;
begin
	// write dongle with appointed UID
    retcode := RY2_Find();
    if retcode < 0 then
    begin
        FmtStr(str,'ERROR: %x;', [retcode]);
        List.Items.Add(str);
        Exit;
    end;
    if retcode = 0 then
    begin
        List.Items.Add('ERROR: Not found any rockey2');
        Exit;
    end ;
    FmtStr(str,'Find: %x rockey2;', [retcode]);
    List.Items.Add(str);

    str := Inputbox('Input','please input uid : ','715400947');
    List.Items.Add(str);
    uid := StrToInt(str);
    retcode := RY2_Open(1, uid, @hid);
    if retcode < 0 then
    begin
        FmtStr(str,'ERROR: %x', [retcode]);
        List.Items.Add(str);
        Exit;
    end;
    handle := retcode;

    str := Inputbox('Input','Please input write block index(0-4)','0');
    block_index := StrToInt(str);
    str1 := Inputbox('Input','Please input write data :','helloworld');
    retcode := RY2_Write(handle, block_index, PAnsiChar(str1));
    if  retcode < 0 then
    begin
        FmtStr(str, 'ERROR: %x', [retcode]);
        List.Items.Add(str);
        Exit;
    end;
    List.Items.Add('Write OK');
    RY2_Close(handle);
end;

procedure TForm1.Button4Click(Sender: TObject);
var
retcode ,handle,block_index:integer;
uid,hid:cardinal;
buffer :array [0..512]of AnsiChar;
str:string;
pchars :PAnsiChar;
begin
   // read dongle with appointed UID
    retcode := RY2_Find();
    if retcode < 0 then
    begin
        FmtStr(str,'ERROR: %x;', [retcode]);
        List.Items.Add(str);
        Exit;
    end;
    if retcode = 0 then
    begin
        List.Items.Add('ERROR: Not found any rockey2');
        Exit;
    end ;
    FmtStr(str,'Find: %x rockey2;', [retcode]);
    List.Items.Add(str);
    str := Inputbox('Input','please input uid : ','715400947');
    uid := StrToInt(str);
    retcode := RY2_Open(1, uid, @hid);
    if retcode < 0 then
    begin
        FmtStr(str, 'ERROR: %x', [retcode]);
        List.Items.Add(str);
        Exit;
    end;
    handle := retcode;

    str := Inputbox('Input','Please input write block index(0-4)','0');
    block_index := StrToInt(str);
    retcode := RY2_Read(handle, block_index, buffer);
    if retcode < 0 then
    begin
        FmtStr(str, 'ERROR: %x', [retcode]);
        List.Items.Add(str);
        Exit;
   end;
   pchars := buffer;
   str := 'Readed data: '+pchars;
   List.Items.Add(str);
   RY2_Close(handle);
end;

procedure TForm1.Button1Click(Sender: TObject);
var
retcode ,handle,block_len:integer;
uid,hid:cardinal;
i:integer;
buffer :array [0..31]of Char;
str:string;
pchars :PChar;
begin
	// read dongle with appointed UID
    retcode := RY2_Find();
    if retcode < 0 then
    begin
        FmtStr(str,'ERROR: %x;', [retcode]);
        List.Items.Add(str);
        Exit;
    end;
    if retcode = 0 then
    begin
        List.Items.Add('ERROR: Not found any rockey2');
        Exit;
    end ;
    FmtStr(str,'Find: %x rockey2;', [retcode]);
    List.Items.Add(str);
    str := Inputbox('Input','please input uid : ','715400947');
    uid := StrToInt(str);
    retcode := RY2_Open(1, uid, @hid);
    if retcode < 0 then
    begin
        FmtStr(str, 'ERROR: %x', [retcode]);
        List.Items.Add(str);
        Exit;
    end;
    handle := retcode;

    FillChar(buffer,sizeof(buffer),0);
    for i:=0 to 9 do
    begin
       buffer[i]:='h';
    end;
    pchars := buffer;
    str := 'translate data: '+pchars;
    List.Items.Add(str);
    block_len := strlen(buffer);
    retcode := RY2_Transform(handle, block_len, @buffer[0]);
    if retcode < 0 then
    begin
        FmtStr(str, 'ERROR: %x', [retcode]);
        List.Items.Add(str);
        Exit;
   end;
   pchars := buffer;
   str := 'translate into: '+pchars;
   List.Items.Add(str);
   RY2_Close(handle);

end;

end.
